CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	msgFinal text := 'CRIADA';
BEGIN 

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 20231006
'Job.................:  
'Nome................: v_est_prod_tbl_desc_qtde_tipos 
'Objetivo............: 
'Tabelas.............: 
'Dt Criação..........: 
'Criado por..........: 
'Dt Ult Alteracão....: 06/10/2023
'Revisado por........: Marcos Barros
'Alterado por........: Gerson Reis

'=======================================================================================
-- FARMAGOI-38891
*/


CREATE OR REPLACE VIEW public.v_est_prod_tbl_desc_qtde_tipos AS 
SELECT tb.cd_emp,
    f.cd_filial,
    tb.cd_tbl_desc_qtde,
    tb.ds_tbl_desc_qtde,
    tb.dt_ini,
    tb.dt_fim,
    tb.cd_tp_desconto,
    g.ds_tp_desconto,
    tb.sts_tbl_desc,
    tb.cd_prod,
    tb.ds_hierarquia,
    tb.perc_desc,
    tb.perc_desc_max,
    tb.sobrepor_oferta,
    tb.preco_especifico,
    tb.tp_desconto,
    tb.flag_envio_propz,
    tb.flag_tp_desconto_propz
   FROM ( SELECT d.cd_emp,
            d.cd_tbl_desc_qtde,
            d.ds_tbl_desc_qtde,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            a.cd_prod,
            'linha'::text AS ds_hierarquia,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz
           FROM est_prod_tbl_desc_qtde d
             JOIN est_prod_tbl_desc_qtde_est_arv_merc_linha l ON d.cd_emp = l.cd_emp AND d.cd_tbl_desc_qtde = l.cd_tbl_desc_qtde
             JOIN est_prod_est_arv_mercadologica a ON l.cd_emp = a.cd_emp AND l.cd_arv_merc_linha = a.cd_arv_merc_linha
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc_qtde,
            d.ds_tbl_desc_qtde,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            a.cd_prod,
            'categoria'::text AS ds_hierarquia,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz
           FROM est_prod_tbl_desc_qtde d
             JOIN est_prod_tbl_desc_qtde_est_arv_merc_categoria c ON d.cd_emp = c.cd_emp AND d.cd_tbl_desc_qtde = c.cd_tbl_desc_qtde
             JOIN est_prod_est_arv_mercadologica a ON c.cd_emp = a.cd_emp AND c.cd_arv_merc_categ = a.cd_arv_merc_categ
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc_qtde,
            d.ds_tbl_desc_qtde,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            p.cd_prod,
            'fabricante'::text AS ds_hierarquia,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz
           FROM est_prod_tbl_desc_qtde d
             JOIN est_prod_tbl_desc_qtde_est_prod_fabric f_1 ON d.cd_emp = f_1.cd_emp AND d.cd_tbl_desc_qtde = f_1.cd_tbl_desc_qtde
             JOIN est_prod p ON f_1.cd_emp::numeric = p.cd_emp AND f_1.cd_fabric = p.cd_fabric
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc_qtde,
            d.ds_tbl_desc_qtde,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            p.cd_prod,
            'marca'::text AS ds_hierarquia,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz
           FROM est_prod_tbl_desc_qtde d
             JOIN est_prod_tbl_desc_qtde_est_mc m ON d.cd_emp = m.cd_emp AND d.cd_tbl_desc_qtde = m.cd_tbl_desc_qtde
             JOIN est_prod p ON m.cd_emp::numeric = p.cd_emp AND m.cd_mc = p.cd_mc
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc_qtde,
            d.ds_tbl_desc_qtde,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            a.cd_prod,
            'familia'::text AS ds_hierarquia,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz
           FROM est_prod_tbl_desc_qtde d
             JOIN est_prod_tbl_desc_qtde_est_arv_merc_familia e ON d.cd_emp = e.cd_emp AND d.cd_tbl_desc_qtde = e.cd_tbl_desc_qtde
             JOIN est_prod_est_arv_mercadologica a ON e.cd_emp = a.cd_emp AND e.cd_arv_merc_familia = a.cd_arv_merc_familia
        UNION ALL
         SELECT d.cd_emp,
            d.cd_tbl_desc_qtde,
            d.ds_tbl_desc_qtde,
            d.dt_ini,
            d.dt_fim,
            d.cd_tp_desconto,
            d.sts_tbl_desc,
            t.cd_prod,
            'produto'::text AS ds_hierarquia,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc,
            (1 - d.qtde_pague / d.qtde_leve::numeric) * 100::numeric AS perc_desc_max,
            0 AS sobrepor_oferta,
            0 AS preco_especifico,
            2 AS tp_desconto,
            d.flag_envio_propz,
            d.flag_tp_desconto_propz
           FROM est_prod_tbl_desc_qtde d
             JOIN est_prod_tbl_desc_qtde_est_prod t ON d.cd_emp = t.cd_emp AND d.cd_tbl_desc_qtde = t.cd_tbl_desc_qtde) tb
     JOIN est_prod_tbl_desc_qtde_prc_filial f ON tb.cd_emp = f.cd_emp AND tb.cd_tbl_desc_qtde = f.cd_tbl_desc_qtde
     JOIN glb_tp_desconto g ON tb.cd_tp_desconto = g.cd_tp_desconto;


  RAISE NOTICE 'Visão v_est_prod_tbl_desc_qtde_tipos FOI %', msgFinal::varchar;

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();
